/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceFilterSelectionActionListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.ExportConcordanceActionListener;
import net.nooj4nlp.controller.ConcordanceShell.ExtractConcordanceActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenStatsActionListener;
import net.nooj4nlp.gui.actions.shells.construct.SyntacticTreeActionListener;
import net.nooj4nlp.gui.components.CursorChangeEffect;

class PopUpConcordance
extends JPopupMenu {
    private static final long serialVersionUID = 1L;

    public PopUpConcordance(final ConcordanceShellController controller, boolean enableSyntacticAndAnnotations) {
        JMenuItem mntmSelectAll = new JMenuItem("Select all");
        this.add(mntmSelectAll);
        mntmSelectAll.addActionListener(new ConcordanceFilterSelectionActionListener(controller, true, false, false));
        JMenuItem mntmUnselectAll = new JMenuItem("Unselect all");
        this.add(mntmUnselectAll);
        mntmUnselectAll.addActionListener(new ConcordanceFilterSelectionActionListener(controller, false, false, false));
        JMenuItem mntmFilterSelectedLines = new JMenuItem("Filter out selected lines");
        this.add(mntmFilterSelectedLines);
        mntmFilterSelectedLines.addActionListener(new ConcordanceFilterSelectionActionListener(controller, false, true, true));
        JMenuItem mntmFilterUnselectedLines = new JMenuItem("Filter out unselected lines");
        this.add(mntmFilterUnselectedLines);
        mntmFilterUnselectedLines.addActionListener(new ConcordanceFilterSelectionActionListener(controller, false, true, false));
        JMenuItem mntmRepeatSegmentsHideHapaxes = new JMenuItem("Repeted segments only / Hide hapaxes");
        this.add(mntmRepeatSegmentsHideHapaxes);
        mntmRepeatSegmentsHideHapaxes.addActionListener(new ConcordanceFilterSelectionActionListener(controller));
        JSeparator separator_1 = new JSeparator();
        this.add(separator_1);
        JMenuItem mntmAddRemoveAnnotations = new JMenuItem("Annotate Text (add/remove annotations)");
        this.add(mntmAddRemoveAnnotations);
        mntmAddRemoveAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    CursorChangeEffect.setCustomCursor(3);
                    controller.annotate();
                }
                finally {
                    CursorChangeEffect.setCustomCursor(0);
                }
            }
        });
        JMenuItem mntmDisplaySyntacticAnalysis = new JMenuItem("Display Syntactic Analysis");
        this.add(mntmDisplaySyntacticAnalysis);
        mntmDisplaySyntacticAnalysis.addActionListener(new SyntacticTreeActionListener(controller));
        if (!enableSyntacticAndAnnotations) {
            mntmAddRemoveAnnotations.setEnabled(false);
            mntmDisplaySyntacticAnalysis.setEnabled(false);
        }
        JSeparator separator_2 = new JSeparator();
        this.add(separator_2);
        JMenuItem mntmExportConcordanceAsText = new JMenuItem("Export Concordance As TXT");
        this.add(mntmExportConcordanceAsText);
        mntmExportConcordanceAsText.addActionListener(new ExportConcordanceActionListener(controller, 1));
        JMenuItem mntmExportConcordanceAsWeb = new JMenuItem("Export Concordance As Web Page");
        this.add(mntmExportConcordanceAsWeb);
        mntmExportConcordanceAsWeb.addActionListener(new ExportConcordanceActionListener(controller, 2));
        JMenuItem mntmExportIndex = new JMenuItem("Export Index");
        this.add(mntmExportIndex);
        mntmExportIndex.addActionListener(new ExportConcordanceActionListener(controller, 3));
        JMenuItem mntmExtractMatchingTU = new JMenuItem("Extract Matching Text Units");
        this.add(mntmExtractMatchingTU);
        mntmExtractMatchingTU.addActionListener(new ExtractConcordanceActionListener(controller, true));
        JMenuItem mntmExtractNonMatchingTU = new JMenuItem("Extract Non Matching Text Units");
        this.add(mntmExtractNonMatchingTU);
        mntmExtractNonMatchingTU.addActionListener(new ExtractConcordanceActionListener(controller, false));
        JMenuItem mntmStatisticalAnalyses = new JMenuItem("Statistical Analyses");
        this.add(mntmStatisticalAnalyses);
        mntmStatisticalAnalyses.addActionListener(new OpenStatsActionListener(controller.getTextController(), controller));
    }
}

